function showConnections(obj)
%SHOWCONNECTIONS Show all connections in the adjacency matrix obj, with
%their weight values
%   Ex: showConnections(chem)
%
%       DVF --> SPCL    28
%           ....

tmp = [obj.rowLabels' obj.columnLabels]; 
w = 0;
for i = 1:numel(tmp)
    w = max(w,length(tmp{i}));
end
w = w+5;
for i = 1:size(obj.A,1)
    for j = 1:size(obj.A,2)
        if (obj.A(i,j) ~= 0)
            fprintf('%s --> %-*s\t%.0f\n',obj.rowLabels{i},w,obj.columnLabels{j},obj.A(i,j));
        end
    end
end

end

